/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.blocks;

import com.github.bartimaeusnek.bartworks.API.ITileAddsInformation;
import com.github.bartimaeusnek.bartworks.API.ITileDropsContent;
import com.github.bartimaeusnek.bartworks.API.ITileHasDifferentTextureSides;
import com.github.bartimaeusnek.bartworks.API.ITileWithGUI;
import com.github.bartimaeusnek.bartworks.MainMod;
import com.github.bartimaeusnek.bartworks.common.tileentities.classic.BW_TileEntity_HeatedWaterPump;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.IHasGui;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidContainerItem;

public class BW_TileEntityContainer
extends BlockContainer
implements ITileAddsInformation {
    protected Class<? extends TileEntity> tileEntity;

    public BW_TileEntityContainer(Material p_i45386_1_, Class<? extends TileEntity> tileEntity, String blockName) {
        super(p_i45386_1_);
        this.tileEntity = tileEntity;
        this.setHardness(15.0f);
        this.setResistance(30.0f);
        this.setCreativeTab(MainMod.BWT);
        this.setBlockName(blockName);
        this.setBlockTextureName("bartworks:" + blockName);
        GregTech_API.registerMachineBlock((Block)this, (int)-1);
    }

    public boolean onBlockActivated(World worldObj, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        if (worldObj.isRemote) {
            return false;
        }
        TileEntity tile = worldObj.getTileEntity(x, y, z);
        if (tile instanceof BW_TileEntity_HeatedWaterPump && player.getHeldItem() != null && (player.getHeldItem().getItem().equals(Items.bucket) || player.getHeldItem().getItem() instanceof IFluidContainerItem) && ((BW_TileEntity_HeatedWaterPump)tile).drain(1000, false) != null && player.getHeldItem().getItem().equals(Items.bucket) && ((BW_TileEntity_HeatedWaterPump)tile).drain((int)1000, (boolean)false).amount == 1000) {
            ((BW_TileEntity_HeatedWaterPump)tile).drain(1000, true);
            --player.getHeldItem().stackSize;
            if (player.getHeldItem().stackSize <= 0) {
                player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
            }
            player.inventory.addItemStackToInventory(new ItemStack(Items.water_bucket));
            return true;
        }
        if (!player.isSneaking()) {
            if (tile instanceof IHasGui) {
                return worldObj.isRemote || IC2.platform.launchGui(player, (IHasGui)tile);
            }
            if (tile instanceof ITileWithGUI) {
                return worldObj.isRemote || ((ITileWithGUI)tile).openGUI(tile, player);
            }
        }
        return false;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof IWrenchable && itemStack != null) {
            IWrenchable tile2 = (IWrenchable)tile;
            int meta = itemStack.getItemDamage();
            world.setBlockMetadataWithNotify(x, y, z, meta, 2);
            if (entity != null) {
                int face = MathHelper.floor_double((double)((double)(entity.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
                switch (face) {
                    case 0: {
                        tile2.setFacing((short)2);
                        break;
                    }
                    case 1: {
                        tile2.setFacing((short)5);
                        break;
                    }
                    case 2: {
                        tile2.setFacing((short)3);
                        break;
                    }
                    case 3: {
                        tile2.setFacing((short)4);
                    }
                }
            }
        }
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        TileEntity t;
        if (GregTech_API.isMachineBlock((Block)this, (int)world.getBlockMetadata(x, y, z))) {
            GregTech_API.causeMachineUpdate((World)world, (int)x, (int)y, (int)z);
        }
        if ((t = world.getTileEntity(x, y, z)) instanceof ITileDropsContent) {
            int[] dropSlots;
            for (int dropSlot : dropSlots = ((ITileDropsContent)t).getDropSlots()) {
                if (((ITileDropsContent)t).getStackInSlot(dropSlot) == null) continue;
                world.spawnEntityInWorld((Entity)new EntityItem(world, (double)x, (double)y, (double)z, ((BW_TileEntity_HeatedWaterPump)t).getStackInSlot(dropSlot)));
            }
        }
        super.breakBlock(world, x, y, z, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (ITileHasDifferentTextureSides.class.isAssignableFrom(this.tileEntity)) {
            try {
                return ((ITileHasDifferentTextureSides)this.tileEntity.newInstance()).getTextureForSide(side, meta);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return super.getIcon(side, meta);
            }
        }
        return super.getIcon(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        if (ITileHasDifferentTextureSides.class.isAssignableFrom(this.tileEntity)) {
            try {
                ((ITileHasDifferentTextureSides)this.tileEntity.newInstance()).registerBlockIcons(par1IconRegister);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        } else {
            super.registerBlockIcons(par1IconRegister);
        }
    }

    public TileEntity createNewTileEntity(World p_149915_1_, int p_149915_2_) {
        try {
            return this.tileEntity.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    @Override
    public String[] getInfoData() {
        if (ITileAddsInformation.class.isAssignableFrom(this.tileEntity)) {
            try {
                return ((ITileAddsInformation)this.tileEntity.newInstance()).getInfoData();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return new String[0];
    }

    public void onBlockAdded(World aWorld, int aX, int aY, int aZ) {
        if (GregTech_API.isMachineBlock((Block)this, (int)aWorld.getBlockMetadata(aX, aY, aZ))) {
            GregTech_API.causeMachineUpdate((World)aWorld, (int)aX, (int)aY, (int)aZ);
        }
    }
}

